<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('factura_fretes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('factura_id')->constrained('facturas')->onDelete('cascade');
            $table->foreignId('frete_id')->constrained('fretes');
            $table->decimal('valor', 10, 2); // valor aplicado na fatura (pode ser diferente do valor original do frete)
            $table->integer('quantidade')->default(1);
            $table->string('descricao')->nullable(); // opcional, para personalizar
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('factura_fretes');
    }
};
