<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
                $table->id();
                $table->foreignId('cliente_id')->nullable()->constrained('clientes');
                $table->foreignId('fornecedor_id')->nullable()->constrained('fornecedors');
                $table->foreignId('custo_operacional_id')->nullable()->constrained('custo_operacionals');
                $table->foreignId('conta_id')->nullable()->constrained('contas');
                $table->foreignId('frete_id')->nullable()->constrained('fretes');
                $table->foreignId('factura_id')->nullable()->constrained('facturas');
                $table->string('descricao');
                $table->decimal('valor', 15, 2);
                $table->date('data_emissao');
                $table->date('data_vencimento');
                $table->date('data_pagamento')->nullable();
                $table->decimal('valor_pago', 15, 2)->nullable();
                $table->string('status'); // pendente, pago_parcial, pago, atrasado
                $table->string('forma_pagamento');
                $table->string('centro_custo')->nullable()->constrained('centro_custos');
                $table->text('observacoes')->nullable();
                $table->timestamps();
                $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
