<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lancamento_contabils', function (Blueprint $table) {
                $table->id();
                $table->enum('tipo', ['entrada', 'saida']);
                $table->foreignId('cliente_id')->nullable()->constrained('clientes');
                $table->foreignId('fornecedor_id')->nullable()->constrained('fornecedors');
                $table->foreignId('conta_id')->nullable()->constrained('contas');
                $table->foreignId('frete_id')->nullable()->constrained('fretes');
                $table->foreignId('factura_id')->nullable()->constrained('facturas');
                $table->foreignId('conta_receber_id')->nullable()->constrained('facturas');
                $table->string('descricao');
                $table->decimal('valor', 15, 2);
                $table->date('data_emissao');
                $table->date('data_pagamento');
                $table->enum('forma_pagamento', ['cash','transferencia', 'deposito bancario', 'cartao_credito','cartao_debito','cheque']);
                $table->string('centro_custo_id')->nullable()->constrained('centro_custos');
                $table->text('observacoes')->nullable();

                $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lancamento_contabils');
    }
};
