<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conta_recebers', function (Blueprint $table) {
                $table->id();
                $table->foreignId('cliente_id')->constrained('clientes')->nullable();
                $table->foreignId('frete_id')->nullable()->constrained('fretes');
                $table->string('descricao');
                $table->string('outros_devedores');
                $table->decimal('valor', 15, 2);
                $table->date('data_emissao');
                $table->date('data_vencimento');
                $table->date('data_pagamento')->nullable();
                $table->decimal('valor_pago', 15, 2)->nullable();
                $table->string('status'); // pendente, pago_parcial, pago, atrasado
                $table->string('numero_lancamento')->nullable();
                $table->text('observacoes')->nullable();
                $table->timestamps();
                $table->softDeletes();
             });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conta_recebers');
    }
};
