<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custo_operacionals', function (Blueprint $table) {
                $table->id();
                $table->string('numero_cop', 20);
                $table->foreignId('viagem_id')->nullable()->constrained('viagems');
                $table->foreignId('veiculo_id')->nullable()->constrained('viaturas');
                $table->date('data');
                $table->foreignId('tipo_custo_op_id')->nullable()->constrained('tipo_custo_ops'); // combustivel, manutencao, pedagio, alimentacao, hospedagem, outros
                $table->string('descricao');
                $table->decimal('valor', 15, 2);
                $table->decimal('quantidade', 10, 2)->nullable(); // litros, diárias, etc
                $table->string('unidade')->nullable(); // litro, diaria, unidade
                $table->foreignId('fornecedor_id')->nullable()->constrained('fornecedors');
                $table->string('numero_documento')->nullable();
                $table->string('forma_pagamento');
                $table->date('data_vencimento');
                $table->enum('status', ['pendente', 'pago', 'cancelado']); // pendente, pago, cancelado
                $table->string('centro_custo_id')->nullable()->constrained('centro_custos'); // viagem, administrativo, manutencao
                $table->timestamps();
                $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custo_operacionals');
    }
};
