<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('centro_custos', function (Blueprint $table) {
                $table->id();
                $table->string('codigo')->unique();
                $table->string('nome');
                $table->string('descricao')->nullable();
                $table->string('tipo'); // viagem, administrativo, manutencao, comercial
                $table->boolean('ativo')->default(true);
                $table->timestamps();
                $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('centro_custos');
    }
};
