<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('viagems', function (Blueprint $table) {
            $table->id();
            $table->foreignId('frete_id')->constrained('fretes');
            $table->string('origem', 80);
            $table->string('numero_viagem', 20);
            $table->string('destino', 80);
            $table->date('data_partida');
            $table->date('d_chegada_prevista')->nullable();
            $table->date('d_chegada_real')->nullable();
            $table->double('distancia')->nullable();
            $table->double('kilometragem_inicial')->nullable();
            $table->double('kilometragem_final')->nullable();
            $table->foreignId('id_motorista')->constrained(table: 'drivers');
            $table->foreignId('id_veiculo')->constrained(table: 'viaturas');
            $table->enum('status', ['Pendente', 'Em preparação', 'Em curso', 'Parada operacional', 'Parada por emergência' , 'Atrasada', 'Concluída', 'Em manutenção']);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('viagems');
    }
};
