<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fretes', function (Blueprint $table) {
            $table->id();
            $table->string('numero_frete', 20);
            $table->decimal('valor_frete', 15, 2);
            $table->decimal('valor_adiantamento', 15, 2)->default(0);
            $table->decimal('valor_seguro', 15, 2)->default(0);
            $table->decimal('valor_portagem', 15, 2)->default(0);
            $table->decimal('valor_outros', 15, 2)->default(0);
            $table->decimal('valor_liquido', 15, 2);
            $table->string('forma_pagamento'); // à vista, parcelado
            $table->integer('parcelas')->default(1);
            $table->date('data_vencimento');
            $table->enum('status_pagamento', ['pendente', 'pago', 'atrasado']); // pendente, pago, atrasado
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('frete_cargas', function (Blueprint $table) {
    $table->foreignId('frete_id')->constrained('fretes')->onDelete('cascade');
    $table->foreignId('carga_id')->constrained('cargas')->onDelete('cascade');
    
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fretes');
        Schema::dropIfExists('frete_carga');
    }
};
