<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('viaturas', function (Blueprint $table) {
            $table->id();
            $table->string('matricula', 10)->unique();
            $table->string('codigo_viatura', 20)->unique();
            $table->string('marca', 50);
            $table->string('modelo', 50);
            $table->year('ano_fabricacao');
            $table->year('ano_aquisicao');
            $table->string('tipo_combustivel', 20);
            $table->string('status', 20)->default('activo');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('veiculos');
    }
};
