<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contas', function (Blueprint $table) {
            $table->id();
            $table->string( 'banco', 100);
            $table->string( 'tipo', 100);
            $table->integer( 'numero')->nullable();
            $table->string( 'nib', 40)->nullable();
            $table->string( 'nuib', 100)->nullable();
            $table->string(   'titular', 100);
            $table->string(   'moeda');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contas');
    }
};
