<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Viatura;
use Illuminate\Auth\Access\HandlesAuthorization;

class ViaturaPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Viatura');
    }

    public function view(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('View:Viatura');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Viatura');
    }

    public function update(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('Update:Viatura');
    }

    public function delete(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('Delete:Viatura');
    }

    public function restore(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('Restore:Viatura');
    }

    public function forceDelete(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('ForceDelete:Viatura');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Viatura');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Viatura');
    }

    public function replicate(AuthUser $authUser, Viatura $viatura): bool
    {
        return $authUser->can('Replicate:Viatura');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Viatura');
    }

}