<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Viagem;
use Illuminate\Auth\Access\HandlesAuthorization;

class ViagemPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Viagem');
    }

    public function view(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('View:Viagem');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Viagem');
    }

    public function update(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('Update:Viagem');
    }

    public function delete(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('Delete:Viagem');
    }

    public function restore(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('Restore:Viagem');
    }

    public function forceDelete(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('ForceDelete:Viagem');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Viagem');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Viagem');
    }

    public function replicate(AuthUser $authUser, Viagem $viagem): bool
    {
        return $authUser->can('Replicate:Viagem');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Viagem');
    }

}