<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Manutencao;
use Illuminate\Auth\Access\HandlesAuthorization;

class ManutencaoPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Manutencao');
    }

    public function view(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('View:Manutencao');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Manutencao');
    }

    public function update(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('Update:Manutencao');
    }

    public function delete(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('Delete:Manutencao');
    }

    public function restore(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('Restore:Manutencao');
    }

    public function forceDelete(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('ForceDelete:Manutencao');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Manutencao');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Manutencao');
    }

    public function replicate(AuthUser $authUser, Manutencao $manutencao): bool
    {
        return $authUser->can('Replicate:Manutencao');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Manutencao');
    }

}