<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\LancamentoContabil;
use Illuminate\Auth\Access\HandlesAuthorization;

class LancamentoContabilPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:LancamentoContabil');
    }

    public function view(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('View:LancamentoContabil');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:LancamentoContabil');
    }

    public function update(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('Update:LancamentoContabil');
    }

    public function delete(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('Delete:LancamentoContabil');
    }

    public function restore(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('Restore:LancamentoContabil');
    }

    public function forceDelete(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('ForceDelete:LancamentoContabil');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:LancamentoContabil');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:LancamentoContabil');
    }

    public function replicate(AuthUser $authUser, LancamentoContabil $lancamentoContabil): bool
    {
        return $authUser->can('Replicate:LancamentoContabil');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:LancamentoContabil');
    }

}