<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Driver extends Model
{
    use HasFactory;
    use SoftDeletes;
	
  protected $fillable = [
      'funcionario_id',
      'codigo',
      'carta_conducao',
      'validade',
      'nome',
      'bi',
      'data_nascimento',
      'local_nascimento',
      'nacionalidade',
      'telefone',
      'email',
      'endereco'
  ];
    
        public function funcionario()
      {
        return $this->belongsTo(Funcionario::class);
      }

      public function abastecimento()
      {
    
        return $this->hasMany(Abastecimento::class);
      }

}
