<?php

namespace App\Livewire;

use App\Models\LancamentoContabil;
use Carbon\Carbon;
use Filament\Widgets\ChartWidget;

class SaldosGraficoWidget extends ChartWidget
{
    // protected ?string $heading = 'Saldos Grafico Widget';

    protected function getData(): array
    {
        $inicio = Carbon::now()->startOfMonth();
        $fim = Carbon::now()->endOfMonth();

        $movimentos = LancamentoContabil::selectRaw('DAY(data_pagamento) as dia, SUM(valor) as total')
            ->whereBetween('data_pagamento', [$inicio, $fim])
            ->groupBy('dia')
            ->orderBy('dia')
            ->get();

        return [
            'datasets' => [
                [
                    'label' => 'Total por dia',
                    'data' => $movimentos->pluck('total'),
                ],
            ],
            'labels' => $movimentos->pluck('dia'),
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
