<?php

namespace App\Livewire;

use App\Models\Conta;
use App\Models\LancamentoContabil;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class MyWidget extends StatsOverviewWidget
{
      protected ?string $heading= 'Saldo das contas';

    // protected ?string $heading = 'Saldo por banco';
    //  protected static ?int $sort = 1;
    // protected static ?string $pollingInterval = '30s';
    protected function getStats(): array
    {
         $contas = Conta::all();
        $stats = [];
        

        
        foreach ($contas as $conta) {
            // Calcula o saldo somando todos os movimentos da conta
            // $saldo = Movimento::where('conta_id', $conta->id)
            //     ->sum('valor');
            
            // Ou se tiver crédito/débito separado
            $saldo = LancamentoContabil::where('conta_id', $conta->id)
                ->sum(\DB::raw('CASE WHEN tipo = "entrada" THEN valor ELSE -valor END'));

            $stats[] = Stat::make($conta->banco, number_format($saldo, 2, ',', '.') . ' MT')
                ->description($this->getStatusSaldo($saldo)) // ou qualquer outro campo
                ->color($this->getColorBasedOnSaldo($saldo))
                ->icon($conta === 'corrente' ? 'heroicon-o-banknotes' : 'heroicon-o-wallet')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => '$dispatch("open-modal", { id: "conta-details-' . $conta->id . '" })',
                ]);
        }

        


       
        return $stats;
        
       
    }

     private function getColorBasedOnSaldo(float $saldo): string
    {
        return match (true) {
            $saldo > 0 => 'success',
            $saldo < 0 => 'danger',
            default => 'warning',
        };
    }

    private function getStatusSaldo(float $saldo): string
    {
        return match (true) {
            $saldo > 0 => 'Saldo positivo',
            $saldo < 0 => 'Saldo negativo',
        };
    }
}
