<?php

namespace App\Filament\Resources\Viaturas;

use App\Filament\Resources\Viaturas\Pages\CreateViatura;
use App\Filament\Resources\Viaturas\Pages\EditViatura;
use App\Filament\Resources\Viaturas\Pages\ListViaturas;
use App\Filament\Resources\Viaturas\Pages\ViewViatura;
use App\Filament\Resources\Viaturas\Schemas\ViaturaForm;
use App\Filament\Resources\Viaturas\Schemas\ViaturaInfolist;
use App\Filament\Resources\Viaturas\Tables\ViaturasTable;
use App\Models\Viatura;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;


class ViaturaResource extends Resource
{
    protected static ?string $model = Viatura::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    
    protected static string | UnitEnum | null $navigationGroup = 'Gestão de Frotas';

    protected static ?string $recordTitleAttribute = 'Viatura';

    public static function form(Schema $schema): Schema
    {
        return ViaturaForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ViaturaInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ViaturasTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListViaturas::route('/'),
            'create' => CreateViatura::route('/create'),
            'view' => ViewViatura::route('/{record}'),
            'edit' => EditViatura::route('/{record}/edit'),
        ];
    }
}
