<?php

namespace App\Filament\Resources\Viaturas\Schemas;

use App\Models\Viatura;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ViaturaInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('codigo_viatura'),
                TextEntry::make('matricula'),
                TextEntry::make('marca'),
                TextEntry::make('modelo'),
                TextEntry::make('ano_fabricacao'),
                TextEntry::make('ano_aquisicao'),
                TextEntry::make('tipo_combustivel'),
                TextEntry::make('status'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Viatura $record): bool => $record->trashed()),
            ]);
    }
}
