<?php

namespace App\Filament\Resources\Viaturas\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Filament\Forms\Components\DatePicker;

class ViaturaForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('codigo_viatura')
                    ->required(),
                TextInput::make('matricula')
                    ->required(),
                TextInput::make('marca')
                    ->required(),
                TextInput::make('modelo')
                    ->required(),
                DatePicker::make('ano_fabricacao')
                    ->native(false)
                    ->format('Y')
                    ->displayFormat('Y')
                    ->required(),
                DatePicker::make('ano_aquisicao')
                    ->native(false)
                    ->format('Y')
                    ->displayFormat('Y')
                    ->required(),
                TextInput::make('tipo_combustivel')
                    ->required(),
                TextInput::make('status')
                    ->required()
                    ->default('ativo'),
            ]);
    }
}
