<?php

namespace App\Filament\Resources\Viagems\Widgets;

use App\Models\Viagem;
use App\Models\Viatura;
use Carbon\Carbon;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class VisaoGeral extends StatsOverviewWidget
{

    
    protected function getStats(): array
    {
        $currentMonth = Carbon::now()->month;
        $currentYear = Carbon::now()->year;

        return [
            Stat::make('Viagens Feitas no mês', Viagem::whereMonth('data_partida', $currentMonth)->whereYear('data_partida', $currentYear)->count()),
            Stat::make('Viagens em Curso',Viagem::where('status', 'Em curso')->count()),
            Stat::make('Viagem Atrasada', Viagem::where('status', 'Atrasada')->count()),
            Stat::make('Em manutenção', Viagem::where('status', 'Em manutenção')->count()),
            Stat::make('Viagens concluidas', Viagem::where('status', 'Concluída')->count()),
            Stat::make('Parada por emergência', Viagem::where('status', 'Parada por emergência')->count()),
            Stat::make('Pendente', Viagem::where('status', 'Pendente')->count()),
        ];
    }

}
