<?php

namespace App\Filament\Resources\Manutencaos;

use App\Filament\Resources\Manutencaos\Pages\CreateManutencao;
use App\Filament\Resources\Manutencaos\Pages\EditManutencao;
use App\Filament\Resources\Manutencaos\Pages\ListManutencaos;
use App\Filament\Resources\Manutencaos\Pages\ViewManutencao;
use App\Filament\Resources\Manutencaos\Schemas\ManutencaoForm;
use App\Filament\Resources\Manutencaos\Schemas\ManutencaoInfolist;
use App\Filament\Resources\Manutencaos\Tables\ManutencaosTable;
use App\Models\Manutencao;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class ManutencaoResource extends Resource
{
    protected static ?string $model = Manutencao::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | UnitEnum | null $navigationGroup = 'Gestão de Frotas';

    protected static ?string $recordTitleAttribute = 'Manutencao';

    public static function form(Schema $schema): Schema
    {
        return ManutencaoForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ManutencaoInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ManutencaosTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListManutencaos::route('/'),
            'create' => CreateManutencao::route('/create'),
            'view' => ViewManutencao::route('/{record}'),
            'edit' => EditManutencao::route('/{record}/edit'),
        ];
    }
}
