<?php

namespace App\Filament\Resources\LancamentoContabils\Widgets;

use App\Models\LancamentoContabil;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Flowframe\Trend\Trend;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;

class SaldosGrafico extends StatsOverviewWidget
{
    use HasPageShield;
    protected ?string $heading= 'Resumo de receitas e despesas';
    protected function getStats(): array
    {
        
        $saldoGeral=LancamentoContabil::sum(\DB::raw('CASE WHEN tipo = "entrada" THEN valor ELSE -valor END'));
         return [
            Stat::make('Saldo do mês', 
                number_format(
                    LancamentoContabil::whereBetween('data_pagamento', [
                        now()->startOfMonth(),
                        now()->endOfMonth()
                    ])->sum(\DB::raw('CASE WHEN tipo = "entrada" THEN valor ELSE -valor END')), 2, ',', '.').' MT' 
                )
                ->description('Valor total entrada este mês')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('success')
                ->chart($this->getChartData('current_month')),
                
            Stat::make('Total de Entradas do mês', 
                number_format(
                    LancamentoContabil::whereBetween('data_pagamento', [
                        now()->startOfMonth(),
                        now()->endOfMonth()
                    ])
                    ->where('tipo', '=', 'entrada')
                    ->sum('valor'), 2, ',', '.').' MT' 
                )
                ->description('Valor das receitas do mês')
                ->descriptionIcon('heroicon-m-chart-bar')
                ->color('warning'),

            Stat::make('Total de Saidas',
                number_format(
                    LancamentoContabil::whereBetween('data_pagamento', [
                        now()->startOfMonth(),
                        now()->endOfMonth()
                    ])
                    ->where('tipo', '=', 'saida')
                    ->sum('valor'), 2, ',', '.').' MT' 
                )
                ->description('Valor de despesas do mês')
                ->descriptionIcon('heroicon-m-arrow-up')
                ->color('danger'),

            Stat::make('Saldo Global', 
                number_format($saldoGeral, 2, ',', '.').' MT' 
                )
                ->description('Valor total lançado este mês')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color($this->getColorBasedOnSaldoGeral($saldoGeral))
                ->chart($this->getChartData('current_month')),
                
            
        ];
    }

    private function getChartData(string $period): array
    {
        $data = Trend::model(LancamentoContabil::class)
            ->between(
                start: now()->startOfMonth(),
                end: now()->endOfMonth(),
            )
            ->perDay()
            ->sum('valor');
            
        return $data->map(fn ($value) => $value->aggregate)->toArray();
    }

    private function getColorBasedOnSaldoGeral(float $saldoGeral): string
    {
        return match (true) {
            $saldoGeral > 0 => 'success',
            $saldoGeral < 0 => 'danger',
            default => 'warning',
        };
    }
}
