<?php

namespace App\Filament\Resources\LancamentoContabils\Schemas;

use App\Models\LancamentoContabil;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class LancamentoContabilInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('data')
                    ->date(),
                TextEntry::make('tipo'),
                TextEntry::make('conta_contabil'),
                TextEntry::make('descricao'),
                TextEntry::make('valor')
                    ->numeric(),
                TextEntry::make('centro_custo_id')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('documento_referencia')
                    ->placeholder('-'),
                TextEntry::make('tipo_documento')
                    ->placeholder('-'),
                TextEntry::make('documento_id')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (LancamentoContabil $record): bool => $record->trashed()),
            ]);
    }
}
