<?php

namespace App\Filament\Resources\LancamentoContabils;

use App\Filament\Resources\LancamentoContabils\Pages\CreateLancamentoContabil;
use App\Filament\Resources\LancamentoContabils\Pages\EditLancamentoContabil;
use App\Filament\Resources\LancamentoContabils\Pages\ListLancamentoContabils;
use App\Filament\Resources\LancamentoContabils\Pages\ViewLancamentoContabil;
use App\Filament\Resources\LancamentoContabils\Schemas\LancamentoContabilForm;
use App\Filament\Resources\LancamentoContabils\Schemas\LancamentoContabilInfolist;
use App\Filament\Resources\LancamentoContabils\Tables\LancamentoContabilsTable;
use App\Models\LancamentoContabil;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class LancamentoContabilResource extends Resource
{
    protected static ?string $model = LancamentoContabil::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | \UnitEnum | null $navigationGroup = 'Contabilidade';

    protected static ?string $recordTitleAttribute = 'Lancamento Contabils';
    protected static ?string $navigationLabel = 'Diario';

    public static function form(Schema $schema): Schema
    {
        return LancamentoContabilForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return LancamentoContabilInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return LancamentoContabilsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListLancamentoContabils::route('/'),
            'create' => CreateLancamentoContabil::route('/create'),
            'view' => ViewLancamentoContabil::route('/{record}'),
            'edit' => EditLancamentoContabil::route('/{record}/edit'),
        ];
    }
}
