<?php

namespace App\Filament\Resources\Drivers\Schemas;

use App\Models\Driver;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class DriverInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                
                TextEntry::make('codigo'),
                TextEntry::make('nome'),
                TextEntry::make('bi')->label('Bilhete de Identidade:'),
                TextEntry::make('data_nascimento'),
                TextEntry::make('local_nascimento'),
                TextEntry::make('nacionalidade'),
                TextEntry::make('telefone')
                    ->placeholder('-'),
                TextEntry::make('email')
                    ->label('Email address')
                    ->placeholder('-'),
                TextEntry::make('endereco')
                    ->placeholder('-'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Driver $record): bool => $record->trashed()),
//for here
                
                
            ]);
    }
}
