<?php

namespace App\Filament\Resources\ContaRecebers;

use App\Filament\Resources\ContaRecebers\Pages\CreateContaReceber;
use App\Filament\Resources\ContaRecebers\Pages\EditContaReceber;
use App\Filament\Resources\ContaRecebers\Pages\ListContaRecebers;
use App\Filament\Resources\ContaRecebers\Pages\ViewContaReceber;
use App\Filament\Resources\ContaRecebers\Schemas\ContaReceberForm;
use App\Filament\Resources\ContaRecebers\Schemas\ContaReceberInfolist;
use App\Filament\Resources\ContaRecebers\Tables\ContaRecebersTable;
use App\Models\ContaReceber;
use BackedEnum;
use Carbon\Carbon;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class ContaReceberResource extends Resource
{
    protected static ?string $model = ContaReceber::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | \UnitEnum | null $navigationGroup = 'Contabilidade';

    protected static ?string $recordTitleAttribute = 'Conta_receber';

    public static function form(Schema $schema): Schema
    {
        return ContaReceberForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ContaReceberInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ContaRecebersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListContaRecebers::route('/'),
            'create' => CreateContaReceber::route('/create'),
            'view' => ViewContaReceber::route('/{record}'),
            'edit' => EditContaReceber::route('/{record}/edit'),
        ];
    }


}
