<?php

namespace App\Filament\Resources\ContaPagars\Schemas;

use App\Models\ContaPagar;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ContaPagarInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('fornecedor_id')
                ->label('Fornecedor')
                    ->numeric(),
                TextEntry::make('custo_operacional.numero_cop')
                ->label('Custo Operacional')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('descricao'),
                TextEntry::make('valor')
                    ->numeric(),
                TextEntry::make('data_emissao')
                    ->date(),
                TextEntry::make('data_vencimento')
                    ->date(),
                TextEntry::make('data_pagamento')
                    ->date()
                    ->placeholder('-'),
                TextEntry::make('valor_pago')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('status'),
                TextEntry::make('forma_pagamento'),
                TextEntry::make('centro_custo.nome')
                ->label('Centro de Custo'),
                TextEntry::make('observacoes')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (ContaPagar $record): bool => $record->trashed()),
            ]);
    }
}
