<?php

namespace App\Filament\Resources\ContaPagars\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;

class ContaPagarForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([

                Select::make('fornecedor_id')
                ->relationship('fornecedor', 'nome')
                    ->required()
                    ->label('Fornecedor/Credor'),
                TextInput::make('descricao')
                    ->required(),
                TextInput::make('valor')
                    ->required()
                    ->numeric(),
                DatePicker::make('data_emissao')
                    ->required(),
                DatePicker::make('data_vencimento')
                    ->required(),
                DatePicker::make('data_pagamento'),
                TextInput::make('valor_pago')
                    ->numeric(),
                Select::make('status')
                    ->options(['pendente' => 'Pendente', 'pago' => 'Pago', 'cancelado' => 'Cancelado'])
                    ->required(),
                Select::make('forma_pagamento')
                ->options(['cash'=>'Cash','transferencia'=> 'Transferencia', 'deposito bancario'=>'Deposito bancario']),
                Select::make('centro_custo_id')
                ->relationship('centro_custo', 'nome')
                    ->required(),
                Textarea::make('observacoes')
                    ->columnSpanFull(),
            ]);
    }
}
