<?php

namespace App\Filament\Resources\Abastecimentos\Schemas;

use App\Models\Abastecimento;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class AbastecimentoInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('id_veiculo')
                    ->numeric(),
                TextEntry::make('motorista.funcionario.nome')
                    ->numeric(),
                TextEntry::make('kilometragem')
                    ->numeric(),
                TextEntry::make('quantidade')
                    ->numeric(),
                TextEntry::make('valor')
                    ->numeric(),
                TextEntry::make('posto_abstecimento'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Abastecimento $record): bool => $record->trashed()),
            ]);
    }
}
